package fr.asip.cps3.exemple.vues.ecrans;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.BarreStatut;

/**
 * Classe abstraite permettant de modliser un cran de rsultat ou de saisie
 */
public abstract class Ecran {
	
	/**
	 * Type cran
	 */
	protected int type = 0;
	
	/**
	 * Barre de statut
	 */
	protected BarreStatut barreStatut;		
	
	/**
	 * La fentre accueillant l'cran
	 */
	protected FenetrePrincipale fenetre;	

	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran
	 */
	public Ecran(FenetrePrincipale fenetre) {

		this.fenetre = fenetre;
		barreStatut = new BarreStatut(fenetre.getBarreStatut().getText());
		
	}

	/**
	 * Affiche les champs de l'cran
	 */
    public abstract void affiche();

	/**
	 * Mutateur
	 * @param type Type d'cran
	 */
	public void setType(int type) {
		this.type = type;
	}

	/**
	 * Accesseur
	 * @return Type d'cran
	 */
	public int getType() {
		return type;
	}


    
    
}
